#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//SDF TilesMod01.fsh   by    Oneleven 
//https://www.shadertoy.com/view/csy3Rd
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define T iTime
#define PI 3.141592
#define PIXEL 0.5/iResolution.y
#define BORDERSIZE 180.

#define SMOOTHNESS .04
#define ROWS 30.0
#define COLS 20.0

//Smooth minimum by iq
//https://iquilezles.org/articles/smin/
float smin( float a, float b, float k )
{
    float h = max( k-abs(a-b), 0.0 )/k;
    return min( a, b ) - h*h*k*(1.0/4.0);
}

//SDF functions by iq
//https://iquilezles.org/articles/distfunctions2d
float sdCircle(vec2 p, float r)
{
    return length(p) - r;
}

//https://www.shadertoy.com/view/tt23RR
float sdHexagram( in vec2 p, in float r )
{
    const vec4 k = vec4(-0.5,0.86602540378,0.57735026919,1.73205080757);
    
    p = abs(p);
    p -= 2.0*min(dot(k.xy,p),0.0)*k.xy;
    p -= 2.0*min(dot(k.yx,p),0.0)*k.yx;
    p -= vec2(clamp(p.x,r*k.z,r*k.w),r);
    return length(p)*sign(p.y);
}

//https://www.shadertoy.com/view/tdGSDd
float sdBox( in vec2 p, in vec2 b )
{
    vec2 d = abs(p)-b;
    return length(max(d,vec2(0))) + min(max(d.x,d.y),0.0);
}

float sinTime(float time)
{
    return sin(time) * 0.5 + 0.5;
}

float getSDF(vec2 uv)
{
    float s1 = sdCircle(uv - (iMouse.xy - 0.5 * iResolution.xy)/iResolution.y, 0.05);
    
    float s2 = sdHexagram(uv, 0.05 + sinTime(T*0.5 + 0.5)*0.05);
    float s3 = sdBox(uv - vec2(-0.6,0), vec2(0.02,(sinTime(T) * 0.1)));

    float O = smin(s1,s2,SMOOTHNESS);
    O = smin(O, s3, SMOOTHNESS);
    return O;
}

//Hash without Sine by Dave_Hoskins
//https://www.shadertoy.com/view/4djSRW
float hash12(vec2 p)
{
	vec3 p3  = fract(vec3(p.xyx) * .1031);
    p3 += dot(p3, p3.yzx + 33.33);
    return fract((p3.x + p3.y) * p3.z);
}

vec3 hash31(float p)
{
   vec3 p3 = fract(vec3(p) * vec3(.1031, .1030, .0973));
   p3 += dot(p3, p3.yzx+33.33);
   return fract((p3.xxy+p3.yzz)*p3.zyx); 
}

//https://www.shadertoy.com/view/mdy3DR
vec3 pal(float progress, vec3 scale, vec3 offset, vec3 minC, vec3 maxC)
{
    return (cos((progress * scale + offset + 1.0) * PI) * 0.5 + 0.5) * (maxC - minC) + minC;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord - 0.5 * iResolution.xy)/iResolution.y;
    float sdf = getSDF(uv);
    
    //get tangent via sampling two neibhoring pixels
    vec2 up = uv + vec2(0,PIXEL);
    vec2 right = uv + vec2(PIXEL,0);
    vec2 tangent = normalize(vec2(getSDF(up) - sdf, sdf - getSDF(right)));

    float rows = floor(sdf*ROWS);
    float angle = atan(tangent.y,tangent.x)*COLS/PI + T * 0.5 * ((mod(rows,2.0)*2.0 - 1.0)); //used for border in commented line
    float cols = floor(angle);
    
    float border = smoothstep(0.0, PIXEL * BORDERSIZE, abs(sin(sdf*ROWS*PI)));
    //border *= smoothstep(0.0,0.2/rows,abs(sin(angle*PI))); //produces flickering
    
    vec3 col = vec3(0);
    col = pal(hash12(vec2(rows,cols)), vec3(1.0, 1.3, 1.4), vec3(0.0, 0.25, 0.45), vec3(0.3,0.3,0.4), vec3(1.0,1.0,1.0))*border + (1.0 - border) * vec3(0.0, 0.4, 0.9);
    
    //DEBUG Uncomment
    //col = vec3(tangent, 0);
    //col = hash31(rows);
    //col = hash31(cols);
    
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

